/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.console;

import filenet.sim.api.VWSIMSession;
import filenet.sim.toolkit.console.IVWSIMConsoleStatusListener;
import filenet.sim.toolkit.console.VWSIMBaseNode;
import filenet.sim.toolkit.console.VWSIMConsoleActionCommand;
import filenet.sim.toolkit.console.VWSIMConsoleStatusEvent;
import filenet.sim.toolkit.console.VWSIMFolderNode;
import filenet.sim.toolkit.console.images.VWSIMImageLoader;
import filenet.sim.toolkit.console.resources.VWSIMResource;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWUserInfo;
import filenet.vw.base.VWDebug;
import filenet.vw.base.logging.Logger;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.event.EventListenerList;

public class VWSIMConsoleRootNode
extends VWSIMFolderNode {
    protected static Logger logger = Logger.getLogger("filenet.sim.toolkit.console");
    private static final String m_className = "VWSIMConsoleRootNode";
    private static final ImageIcon nodeIcon16 = VWSIMImageLoader.createImageIcon("root_16.gif");
    private static final String MAPPED_CE_FOLDER_LIST = "sim_console_scope";
    private static final String FOLDER_FILTER_LIMIT = "sim_console_folder_filter_limit";
    private EventListenerList m_listenerList = null;
    private Vector m_mappedLibraryFolderList = new Vector();
    private VWUserInfo m_userInfo = null;

    public VWSIMConsoleRootNode() {
        super(VWSIMResource.ConsoleRoot);
        this.setType(17);
        this.setActionCommandString(VWSIMConsoleActionCommand.ACMD_CONSOLE_ROOT);
        this.setIcon16(nodeIcon16);
        this.m_listenerList = new EventListenerList();
    }

    public void addConsoleStatusListener(IVWSIMConsoleStatusListener csl) {
        this.m_listenerList.add(IVWSIMConsoleStatusListener.class, csl);
    }

    public void init(VWSession vwSession, VWSIMSession simSession) {
        try {
            this.m_vwSession = vwSession;
            this.m_simSession = simSession;
            this.m_userInfo = this.m_vwSession.fetchCurrentUserInfo();
            this.loadFolderFilterLimit();
            this.loadMappedFolderList();
            this.setMappedFolders();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean addMappedFolder(IVWIDMItem idmItem) {
        String m_method = "addMappedFolder";
        boolean bRet = false;
        try {
            if (idmItem != null) {
                String canonicalName = idmItem.getCanonicalName();
                String folderName = VWSIMResource.MappedFolderName.toString(idmItem.getLabel(), idmItem.getLibraryLabel());
                VWSIMFolderNode fNode = new VWSIMFolderNode(idmItem, folderName, this.m_vwSession, this.m_simSession);
                fNode.setType(18);
                fNode.setFolderFilterLimit(this.m_folderFilterLimit);
                fNode.getSubFolders(true);
                this.add(fNode);
                this.m_mappedLibraryFolderList.add(canonicalName);
                this.saveMappedFolderList(true);
                bRet = true;
                if (logger.isFinest()) {
                    logger.finest(m_className, "addMappedFolder", "FOLDER=" + canonicalName);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return bRet;
    }

    public int mappedFolderIndex(IVWIDMItem idmItem) {
        return this.m_mappedLibraryFolderList.indexOf(idmItem.getCanonicalName());
    }

    public void deleteMappedFolder(IVWIDMItem idmItem) {
        String m_method = "deleteMappedFolder";
        int idx = this.m_mappedLibraryFolderList.indexOf(idmItem.getCanonicalName());
        if (idx >= 0) {
            this.m_mappedLibraryFolderList.removeElementAt(idx);
            this.saveMappedFolderList(true);
            if (logger.isFinest()) {
                logger.finest(m_className, "deleteMappedFolder", "delete folder " + idmItem.getCanonicalName());
            }
        }
    }

    private void setMappedFolders() {
        String m_method = "setMappedFolders";
        boolean bListChanged = false;
        try {
            Iterator it = this.m_mappedLibraryFolderList.iterator();
            while (it.hasNext()) {
                String canonicalName = (String)it.next();
                IVWIDMItem idmItem = null;
                try {
                    idmItem = VWIDMBaseFactory.instance().getIDMItem(canonicalName);
                }
                catch (Exception e) {
                    logger.throwing(m_className, "setMappedFolders", e);
                    VWDebug.logException(e);
                    it.remove();
                    bListChanged = true;
                }
                if (idmItem == null) continue;
                String folderName = idmItem.getLabel() + " (" + idmItem.getLibraryLabel() + ")";
                VWSIMFolderNode fNode = new VWSIMFolderNode(idmItem, folderName, this.m_vwSession, this.m_simSession);
                fNode.setType(18);
                fNode.setFolderFilterLimit(this.m_folderFilterLimit);
                fNode.getSubFolders(true);
                this.add(fNode);
                if (!logger.isFinest()) continue;
                logger.finest(m_className, "setMappedFolders", "set folder " + folderName + ", " + canonicalName);
            }
            if (bListChanged) {
                this.saveMappedFolderList(true);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void saveMappedFolderList(boolean bSaveUserInfo) {
        try {
            int sz = this.m_mappedLibraryFolderList.size();
            if (sz > 0) {
                Object[] mapList = new String[sz];
                this.m_mappedLibraryFolderList.copyInto(mapList);
                this.m_userInfo.setFieldValue(MAPPED_CE_FOLDER_LIST, mapList);
            } else {
                this.m_userInfo.setFieldValue(MAPPED_CE_FOLDER_LIST, null);
            }
            if (bSaveUserInfo) {
                this.m_userInfo.save();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void loadMappedFolderList() {
        String m_method = "loadMappedFolderList";
        try {
            String[] mapList = null;
            mapList = (String[])this.m_userInfo.getFieldValue(MAPPED_CE_FOLDER_LIST);
            if (mapList == null) {
                return;
            }
            for (int i = 0; i < mapList.length; ++i) {
                if (logger.isFinest()) {
                    logger.finest(m_className, "loadMappedFolderList", "MAPPED FOLDER=" + mapList[i]);
                }
                this.m_mappedLibraryFolderList.add(mapList[i]);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void loadFolderFilterLimit() {
        try {
            Integer limit = (Integer)this.m_userInfo.getFieldValue(FOLDER_FILTER_LIMIT);
            if (limit != null && limit > 0) {
                this.m_folderFilterLimit = limit;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void saveFolderFilterLimit(boolean bSaveUserInfo) {
        try {
            Integer limit = new Integer(this.m_folderFilterLimit);
            this.m_userInfo.setFieldValue(FOLDER_FILTER_LIMIT, limit);
            if (bSaveUserInfo) {
                this.m_userInfo.save();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void saveUserPreference() {
        try {
            this.saveFolderFilterLimit(false);
            this.saveMappedFolderList(false);
            this.m_userInfo.save();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void fireConfigStatusEvent(VWSIMConsoleStatusEvent evt) {
        if (evt == null) {
            return;
        }
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWSIMConsoleStatusListener.class) continue;
            ((IVWSIMConsoleStatusListener)listeners[i + 1]).consoleStatusChanged(evt);
        }
    }

    public void releaseResources() {
        if (this.m_mappedLibraryFolderList != null) {
            this.m_mappedLibraryFolderList.removeAllElements();
            this.m_mappedLibraryFolderList = null;
        }
        this.m_userInfo = null;
        if (this.m_listenerList != null) {
            Object[] listeners = this.m_listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                this.m_listenerList.remove(IVWSIMConsoleStatusListener.class, (IVWSIMConsoleStatusListener)listeners[i + 1]);
                listeners[i] = null;
                listeners[i + 1] = null;
            }
            this.m_listenerList = null;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            VWSIMBaseNode aBaseNode = (VWSIMBaseNode)this.getChildAt(i);
            int nType = aBaseNode.getType();
            if (nType != 18 && nType != 16) continue;
            ((VWSIMFolderNode)aBaseNode).releaseResources();
        }
        super.releaseResources();
        this.removeFromParent();
    }
}

